/**
 * This file was modified by Wowfunhappy in June 2020, after the original API for currency conversion rates went offline.
 */

/*
Copyright ＿ 2005, Apple Computer, Inc.  All rights reserved.
NOTE:  Use of this source code is subject to the terms of the Software
License Agreement for Mac OS X, which accompanies the code.  Your use
of this source code signifies your agreement to such license terms and
conditions.  Except as expressly granted in the Software License Agreement
for Mac OS X, no other copyright, patent, or other intellectual property
license or right is granted, either expressly or by implication, by Apple.
*/

function performXMLRequest(callback) {
	
	var url = "http://open.er-api.com/v6/latest/USD"
	
	
	
	var req = new XMLHttpRequest();
	req.onload = function(evt) {currencyDataLoaded(evt, req, callback);}
	req.onerror = function() {alert("Request failed.")};
    
	req.overrideMimeType("text/xml");
	req.open("GET", url);
	req.send(null);
	return req;
}


function constructError(string) {
	return {error:true, errorString:string};
}

function currencyDataLoaded(evt, req, callback) {
	var doc;
	try {
		doc = JSON.parse(req.responseText);
		var obj = {error:false, errorString:null, nextUpdate:null, data:[]};
		/*var d = new Date();
		// should refetch if exchange rates are more than 3 hours old
		d.setUTCHours(d.getUTCHours() + 3);
		obj.nextUpdate = d.valueOf();*/
		obj.nextUpdate = doc.time_next_update_unix;
		
		var lastUpdatedDate;
		lastUpdatedDate = doc.time_last_update_utc;
		for (currency in doc.rates) {
			var currencyName;
			if (window.ConverterPlugin) {
			 	currencyName = ConverterPlugin.currencyNameForCode(currency);
			}
			if (typeof currencyName === "undefined") {
				continue;
			}
			
			var rateFromUSDollar = parseFloat(doc.rates[currency]);
			var rateToUSDollar = 1.0 / rateFromUSDollar;
			var symPrecision = computeSymmetricPrecision(rateToUSDollar, rateFromUSDollar);
			
			var newData = {	name: currencyName, 
							iso: currency, 
							lastUpdated: lastUpdatedDate, 
							toBase: rateToUSDollar, 
							fromBase: rateFromUSDollar, 
							precision: symPrecision
						};
			obj.data[obj.data.length] = newData;
		}		
		callback(obj);
	} catch (e) {
		callback(constructError("error parsing currency response: " + e));
	} finally {
		doc = req = null;
	}
}

function sortLocalizedMenuDataArray(a, b) {
	return a.name.localeCompare(b.name);
}




/**
 * The next two functions were in Apple's original, but seemed to be unused. Left wholly unmodified in case they do something.
 */
 
function createDateFromDateTime(dateString, timeString) {
	var array = dateString.split("-");

	var hour = parseFloat(timeString.substr(0,2));
	var min= parseFloat(timeString.substr(3,2));
	var sec = parseFloat(timeString.substr(6,2))
	var meridiam = timeString.substr(9, 2);

	var year = parseFloat(array[0]);
	var month = parseFloat(array[1]);
	var day = parseFloat(array[2]);
	if (isNaN(year) || isNaN(month) || isNaN(day) || isNaN(hour) || isNaN(min)  || isNaN(sec))
		return new Date(Infinity);
	var date =  new Date();
	date.setUTCFullYear(year);
	date.setUTCMonth(month-1);
	date.setUTCDate(day);
	date.setUTCHours(hour);
	date.setUTCMinutes(min);
	date.setUTCSeconds(sec);
	return date;
}

function createNextUpdateDateFromDateTime(dateString, timeString) {	
	var array = dateString.split("/");
	
	var hour = parseInt (timeString.substr(0, 2), 10);
	var minute = parseInt (timeString.substr(3, 2), 10);
	var meridiam = timeString.substr(9, 2);
	
	var date =  new Date(array[2], array[0]-1, array[1], hour, minute); 	
	return date.valueOf();
}
